function test_suite = testConstructor %#ok<STOUT>
initTestSuite;

function d = setup
% Save current vpa precision for restoration later
d = digits;
digits(32)

% No arguments
function testNoInput(~) %#ok<*DEFNU>
out = polysym;
assertEqual(out.Value,'0')

% First argument:
% "X ... can be of class CHAR, POLYSYM, DOUBLE, or SYM ..."
%----------------------------------------------------------------------

function testFirstArgEmptyChar(~)
out = polysym('');
assertTrue(isempty(out))

function testFirstArgEmptyPolysym(~)
out = polysym(polysym.empty);
assertTrue(isempty(out))

function testFirstArgEmptyDouble(~)
out = polysym([]);
assertTrue(isempty(out))

function testFirstArgEmptyCell(~)
out = polysym({});
assertTrue(isempty(out))

function testFirstArgEmptySym(~)
out = polysym(sym(''));
assertTrue(isempty(out))

function testFirstArgEmptyVpa(~)
out = polysym(vpa([]));
assertTrue(isempty(out))

function testFirstArgEmptyMultipleCols(~)
out = polysym(cell(0,2));
assertEqual(size(out),[0 2])

function testFirstArgCharScalar(~)
out = polysym('s');
assertEqual(out.Value,'s');

function testFirstArgPolysym(~)
out = polysym(polysym('s'));
assertEqual(out.Value,'s');

function testFirstArgDouble(~)
out = polysym(pi);
assertEqual(out.Value,'3.14159265358979');

function testDoubleWithSize(~)
out = polysym(pi,[1 2]);
assertEqual(out.Value,'[3.14159265358979 3.14159265358979]');

function testFirstArgDoubleVector(~)
out = polysym([1 2]);
assertEqual(out(1).Value,'1')
assertEqual(out(2).Value,'2')

function testFirstArgDoubleMatrix(~)
out = polysym([1 2; 3 4]);
assertEqual(out(1,1).Value,'1')
assertEqual(out(1,2).Value,'2')
assertEqual(out(2,1).Value,'3')
assertEqual(out(2,2).Value,'4')

function testFirstArgDoubleMatrixWithSize(~)
out = polysym([1 2; 3 4],[1 2]);
assertEqual(out(1,1).Value,'1')
assertEqual(out(1,2).Value,'2')
assertEqual(out(2,1).Value,'3')
assertEqual(out(2,2).Value,'4')
assertEqual(out(1,3).Value,'1')
assertEqual(out(1,4).Value,'2')
assertEqual(out(2,3).Value,'3')
assertEqual(out(2,4).Value,'4')

% function testFirstArgDouble3D(~)
% f = @() polysym(ones(2,2,2));
% assertExceptionThrown(f,'polysym:polysym:tooManyDimensions')

function testFirstArgSym(~)
out = polysym(sym('x'));
assertEqual(out.Value,'x')

function testFirstArgSymArray(~)
out = polysym(sym('x',2));
assertEqual(out,polysym('x',2))

function testCellArray(~)
str1 = '5419351/1725033';
str2 = '10838702/1725033';
out = polysym({str1,str2});
assertEqual(out(1).Value,str1)
assertEqual(out(2).Value,str2)

function testFirstArgVpa(~)
x = vpa(pi);
out = polysym(x);
assertEqual(out.Value,char(x))

function testFirstArgVpaMoreDigits(~)
% A vpa number is always stored with the number of digits specified by the
% function DIGITS.
x = vpa(pi,40);
y = vpa(pi);
out = polysym(x);
assertEqual(out.Value,char(y))

% "... or a CELL array of any of these types."
function testCellstrScalar(~)
out = polysym({'s'});
assertEqual(out.Value,'s');

function testCellstrVector(~)
out = polysym({'s','t'});
assertEqual(size(out),[1 2])
assertEqual(out(1).Value,'s')
assertEqual(out(2).Value,'t')

function testCellstrMatrix(~)
out = polysym({'p','q'; 'r','s'});
assertEqual(size(out),[2 2])
assertEqual(out(1,1).Value,'p')
assertEqual(out(1,2).Value,'q')
assertEqual(out(2,1).Value,'r')
assertEqual(out(2,2).Value,'s')

function testCellStringArray(~)
f = @() polysym({['x';'y']});
assertExceptionThrown(f,'polysym:polysym:wrongSize')

function testCellDouble(~)
out = polysym({pi});
assertEqual(out.Value,'3.14159265358979')

function testCellstr(~)
out = polysym({polysym('x')});
assertEqual(out.Value,'x')

function testCellVpa(~)
x = vpa(pi);
out = polysym({x});
assertEqual(out.Value,upper(char(x)))

% Invalid input should result in an error.
function testInvalidInput(~)
f = @() polysym(int8(1));
assertExceptionThrown(f,'polysym:polysym:invalidInput');

% Char argument:  "X can include formatting instructions as in SPRINTF; the
% default has the form 'A%d_%d' for a matrix."

function testCharScalarWithFormatting(~)
out = polysym('s%d');
assertEqual(out.Value,'s')
  
% Second argument:
% "OBJ=polysym(X,sz), where X is CHAR, also inputs SZ, the size  of the
% desired array."
%----------------------------------------------------------------------

function testCharArraySingleArg(~)
f = @() polysym(['s';'t']);
assertExceptionThrown(f,'polysym:polysym:wrongSize')

function testCharInputWithScalarSize(~)
out = polysym('x',2);
assertEqual(size(out),[2 2])
assertEqual(out(1).Value,'x1_1')
assertEqual(out(2).Value,'x2_1')
assertEqual(out(3).Value,'x1_2')
assertEqual(out(4).Value,'x2_2')

function testCharInputRowVector(~)
out = polysym('x',[1 3]);
assertEqual(size(out),[1 3])
assertEqual(out(1).Value,'x1')
assertEqual(out(2).Value,'x2')
assertEqual(out(3).Value,'x3')

function testCharInputColumnVector(~)
out = polysym('x',[3,1]);
assertEqual(size(out),[3 1])
assertEqual(out(1).Value,'x1')
assertEqual(out(2).Value,'x2')
assertEqual(out(3).Value,'x3')

function testCharInputWithVectorSize(~)
out = polysym('x',[2 2]);
assertEqual(size(out),[2 2])
assertEqual(out(1,1).Value,'x1_1')
assertEqual(out(1,2).Value,'x1_2')
assertEqual(out(2,1).Value,'x2_1')
assertEqual(out(2,2).Value,'x2_2')

function testCharEmptyDimensions(~)
f = @() polysym('x',[]);
assertExceptionThrown(f,'MATLAB:polysym:expectedNonempty')

function testCharIndexZero(~)
out = polysym('x',0);
assertTrue(isempty(out))

function testCharIndexZeroVector(~)
out = polysym('x',[1 0]);
assertTrue(isempty(out))

function testCharIndexOne(~)
out = polysym('x',1);
assertEqual(out.Value,'x')

% function testCharTooManyDimensions(~)
% f = @() polysym('x',[2 2 2]);
% assertExceptionThrown(f,'polysym:polysym:tooManyDimensions')

function testCharFormattedRowVector(~)
out = polysym('x%d',[3 1]);
assertEqual(size(out),[3 1])
assertEqual(out(1).Value,'x1')
assertEqual(out(2).Value,'x2')
assertEqual(out(3).Value,'x3')

% "Complex numbers are represented in the form 'X+Y*I', where X and Y  are
% polynomial expressions and 'I' is reserved for the square root of  -1."
function testSquareRootMinusOne(~)
out = polysym(sqrt(-1));
assertEqual(out.Value,'1*I')

function testImaginaryIntegerMultiplier(~)
out = polysym(5*sqrt(-1));
assertEqual(out.Value,'5*I')

function testImaginaryIntegerMultiplierVector(~)
out = polysym([3 4]*sqrt(-1));
assertEqual(out(1).Value,'3*I')
assertEqual(out(2).Value,'4*I')

function testImaginaryRealMultiplier(~)
out = polysym(pi*1i);
assertEqual(out.Value,'3.14159265358979*I')

function testComplexInput(~)
out = polysym(4+6i);
assertEqual(out.Value,'4+6*I')

function testVpaComplex(~)
x = vpa('sqrt(2)*(1+i)');
out = polysym(x);
assertEqual(out.Value,upper(char(x)))

function teardown(d)
digits(d);